<?php
/**
 * ServiceProvider.php 2020-3-30
 * Gambio GmbH
 * http://www.gambio.de
 * Copyright (c) 2020 Gambio GmbH
 * Released under the GNU General Public License (Version 2)
 * [http://www.gnu.org/licenses/gpl-2.0.html]
 */

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Database\Image;

use Gambio\Shop\SellingUnit\Images\Builders\CollectionBuilder;
use Gambio\Shop\SellingUnit\Images\Builders\OnlyPropertyImageCollectionBuilder;
use Gambio\Shop\SellingUnit\Images\ValueObjects\SelectedCollectionType;
use GmConfigurationServiceInterface;
use InvalidArgumentException;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use StaticGXCoreLoader;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\SellingUnit\Database\Image
 * @property-read Container $container
 */
class ServiceProvider  extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var string[]
     */
    protected $provides = [
        CollectionBuilder::class,
        OnlyPropertyImageCollectionBuilder::class,
        SelectedCollectionType::class
    ];
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(CollectionBuilder::class);
        $this->container->share(OnlyPropertyImageCollectionBuilder::class);
        $this->container->share(SelectedCollectionType::class)->addArgument($this->imageCollectionBuilderClass());
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
    
    }
    
    
    /**
     * @return string
     */
    protected function imageCollectionBuilderClass(): string
    {
        /** @var GmConfigurationServiceInterface $gxConfigurationService */
        $gxConfigurationService = StaticGXCoreLoader::getService('GmConfiguration');
        $configuration          = $gxConfigurationService->getConfigurationByKey('DISPLAY_OF_PROPERTY_COMBINATION_SELECTION');
        
        switch ($configuration->value()) {
            
            case 'DISPLAY_PROPERTY_PLUS_ARTICLE_IMAGES':
                
                return CollectionBuilder::class;
                
            case 'DISPLAY_ONLY_PROPERTY_IMAGES':
                
                return OnlyPropertyImageCollectionBuilder::class;
            
            default:
                throw new InvalidArgumentException('No class is associated with the value ' . $configuration->value());
        }
    }
}